require( "HiddenObject/script/style.lua" );

CheckBoxFont = {
  standardFont,
  18,
  WhiteColor
};


RectGraphics = {
	"HiddenObject/UI/Button/rectnormal.png",
	"HiddenObject/UI/Button/rectdown.png",
	"HiddenObject/UI/Button/rectover.png",
};	

RectStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = RectGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

DialogBodyFont = {
  standardFont,
  22,
  WhiteColor
};

MakeDialog
{
	-- Name the modal dialog
	name="penaltyForcedHelp",
	Bitmap
	{
		image="HiddenObject/UI/background/dialog",
		x = kCenter,
		y = kCenter - 44,
		
		Text
			{
				font = DialogBodyFont,
				name = "warningmsg",
				x = 145,
				y = 30,
				w = kMax,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "warningmsg",
			};
			
			Text
			{
				font = DialogBodyFont,
				name = "DontShowAgain",
				x = 70,
				y = 95,
				w = kMax - 60,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "penaltymsg",
			};						
		
		SetStyle(CheckboxButtonStyle),			
		Button
		{
			x = 70,
			y = 145,
			w = 300,
			scale = 0.7,
			
			Text
				{
					font = CheckBoxFont,
					name = "DontShowAgain",
					x=kCenter + 20,
					y=5,
					w=kMax,
					h=32,
					flags = kHAlignLeft + kVAlignTop,
					label = "DontShowAgain",					
				};
			command =
				function()
					ToggleForcedPenaltyHelp();
				end				
		},
		
		SetStyle(RectStyle),
		Button
        {
			font = StandardButtonFont,
			graphics = RectGraphics,
            close = true,
            flags = 5,
            label = "ok",
            name = "ok",
            x = kCenter,
            y = -75,
        },
	},
}